function reminderFox_saveOptions() {
	var newTodo = window.arguments[0].todo;		
	var success = reminderFox_saveTodoOptions( newTodo );
	if ( success ) {			
		window.arguments[0].addTodo = true;
	
		window.close();
	}
}


function reminderFox_saveTodoOptions(newTodo) {
	var success = saveEvent( newTodo );
	if ( !success ) {
		return false;
	}
			
	var showInTooltip = document.getElementById("showInTooltip");
	var showInTooltipVal =  showInTooltip.getAttribute("checked" );
	if ( showInTooltipVal == true || showInTooltipVal == "true" ) { 
		newTodo.showInTooltip = true;
	}
	else {
		newTodo.showInTooltip = false;
	}			
	return true;	
}


function loadTodoOptions() {
	var newTodo = window.arguments[0].todo;
	var editing = window.arguments[0].editing;
	var copying = window.arguments[0].copying;
	if ( editing && !copying ) {
		document.title = 	reminderFoxBundle.getString("rf.options.todo.edit.title");
	}
	else {
		document.title = 	reminderFoxBundle.getString("rf.options.todo.add.title");
	}		
	
	loadTodos( newTodo, editing );
}


function loadTodos( newTodo, editing ) {
	loadEvent( newTodo, editing );
					
	var showInTooltip = document.getElementById("showInTooltip");	
	var showInTooltipDefault = true;
	if ( !editing ) {
		try {
			showInTooltipDefault =  reminderFox_getPreferenceValue( REMINDER_FOX_DEFAULT_SHOW_IN_TOOLTIP );	
			if ( showInTooltipDefault || newTodo.showInTooltip == true  ) {
					showInTooltip.setAttribute( "checked", true );
			}
			else {
					showInTooltip.setAttribute( "checked", false );
			}
		} catch(e) {
		}	
	}
	else {					
		if ( newTodo.showInTooltip == true ) {
				showInTooltip.setAttribute( "checked", true );
		}
		else {
				showInTooltip.setAttribute( "checked", false );
		}
	}	
}